<?php $__env->startSection('title', 'Hardware Registrado'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between mb-4">
    <h2>Configuraciones de Hardware</h2>
    <a href="<?php echo e(route('hardwares.create')); ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Nuevo Hardware
    </a>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="table-responsive">
    <table class="table table-striped table-hover align-middle">
        <thead class="table-light">
            <tr>
                <th>ID</th>
                <th>Procesador</th>
                <th>RAM</th>
                <th>Almacenamiento</th>
                <th>Tipo</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $hardwares; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($hw->id_hardware); ?></td>
                    <td><?php echo e($hw->procesador ?? 'N/A'); ?></td>
                    <td><?php echo e($hw->ram_gb); ?> GB</td>
                    <td><?php echo e($hw->almacenamiento_gb); ?> GB</td>
                    <td>
                        <span class="badge bg-<?php echo e($hw->tipo_almacenamiento == 'SSD' ? 'success' : ($hw->tipo_almacenamiento == 'NVMe' ? 'primary' : 'secondary')); ?>">
                            <?php echo e($hw->tipo_almacenamiento); ?>

                        </span>
                    </td>
                    <td>
                        <a href="<?php echo e(route('hardwares.show', $hw)); ?>" class="btn btn-sm btn-info" title="Ver">
                            <i class="bi bi-eye"></i>
                        </a>
                        <a href="<?php echo e(route('hardwares.edit', $hw)); ?>" class="btn btn-sm btn-warning" title="Editar">
                            <i class="bi bi-pencil"></i>
                        </a>
                        <form action="<?php echo e(route('hardwares.destroy', $hw)); ?>" method="POST" class="d-inline" onsubmit="return confirm('¿Eliminar este hardware? Esta acción no se puede deshacer.')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-danger" title="Eliminar">
                                <i class="bi bi-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="text-center text-muted">No hay configuraciones de hardware registradas.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Andespc\resources\views/admin/hardwares/index.blade.php ENDPATH**/ ?>