<?php $__env->startSection('title', 'Sistemas Operativos'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between mb-4">
    <h2>Sistemas Operativos</h2>
    <a href="<?php echo e(route('sistemaoperativos.create')); ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Nuevo SO
    </a>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<table class="table table-striped table-hover align-middle">
    <thead class="table-light">
        <tr>
            <th>ID</th>
            <th>Nombre</th>
            <th>Edición</th>
            <th>Versión</th>
            <th>Acciones</th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $sistemaoperativos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $so): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($so->id_so); ?></td>
                <td><?php echo e($so->nombre_so); ?></td>
                <td><?php echo e($so->edicion ?? 'N/A'); ?></td>
                <td><?php echo e($so->version ?? 'N/A'); ?></td>
                <td>
                    <a href="<?php echo e(route('sistemaoperativos.show', $so)); ?>" class="btn btn-sm btn-info"><i class="bi bi-eye"></i></a>
                    <a href="<?php echo e(route('sistemaoperativos.edit', $so)); ?>" class="btn btn-sm btn-warning"><i class="bi bi-pencil"></i></a>
                    <form action="<?php echo e(route('sistemaoperativos.destroy', $so)); ?>" method="POST" class="d-inline" onsubmit="return confirm('¿Eliminar este sistema?')">
                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-sm btn-danger"><i class="bi bi-trash"></i></button>
                    </form>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="5" class="text-center text-muted">No hay sistemas registrados.</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Andespc\resources\views/admin/sistemaoperativos/index.blade.php ENDPATH**/ ?>