<?php $__env->startSection('title', 'Oficinas'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between mb-4">
    <h2>Oficinas</h2>
    <a href="<?php echo e(route('oficinas.create')); ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Nueva Oficina
    </a>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<table class="table table-striped table-hover align-middle">
    <thead class="table-light">
        <tr>
            <th>ID</th>
            <th>Nombre</th>
            <th>Agencia</th>
            <th>Acciones</th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $oficinas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $oficina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($oficina->id_oficina); ?></td>
                <td><?php echo e($oficina->nombre_oficina); ?></td>
                <td><?php echo e($oficina->agencia->nombre_agencia ?? 'N/A'); ?></td>
                <td>
                    <a href="<?php echo e(route('oficinas.show', $oficina)); ?>" class="btn btn-sm btn-info" title="Ver">
                        <i class="bi bi-eye"></i>
                    </a>
                    <a href="<?php echo e(route('oficinas.edit', $oficina)); ?>" class="btn btn-sm btn-warning" title="Editar">
                        <i class="bi bi-pencil"></i>
                    </a>
                    <form action="<?php echo e(route('oficinas.destroy', $oficina)); ?>" method="POST" class="d-inline" onsubmit="return confirm('¿Eliminar esta oficina? Esta acción no se puede deshacer.')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-sm btn-danger" title="Eliminar">
                            <i class="bi bi-trash"></i>
                        </button>
                    </form>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="5" class="text-center text-muted">No hay oficinas registradas.</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Andespc\resources\views/admin/oficinas/index.blade.php ENDPATH**/ ?>