<?php $__env->startSection('title', 'Editar Equipo'); ?>

<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
    <div class="col-md-10">
        <div class="card shadow-sm">
            <div class="card-header bg-warning text-white">
                <h5><i class="bi bi-pencil-square"></i> Editar Equipo: <?php echo e($equipo->nombre_dispositivo); ?></h5>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('equipos.update', $equipo)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <!-- Nombre y serie -->
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="nombre_dispositivo" class="form-label">Nombre del Dispositivo *</label>
                            <input type="text" name="nombre_dispositivo" id="nombre_dispositivo" class="form-control <?php $__errorArgs = ['nombre_dispositivo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('nombre_dispositivo', $equipo->nombre_dispositivo)); ?>" required>
                            <?php $__errorArgs = ['nombre_dispositivo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <label for="numero_serie" class="form-label">Número de Serie</label>
                            <input type="text" name="numero_serie" id="numero_serie" class="form-control" value="<?php echo e(old('numero_serie', $equipo->numero_serie)); ?>">
                        </div>
                    </div>

                    <!-- IP y fecha -->
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="direccion_ip" class="form-label">Dirección IP</label>
                            <input type="text" name="direccion_ip" id="direccion_ip" class="form-control" value="<?php echo e(old('direccion_ip', $equipo->direccion_ip)); ?>">
                        </div>
                        <div class="col-md-6">
                            <label for="fecha_adquisicion" class="form-label">Fecha de Adquisición</label>
                            <input type="date" name="fecha_adquisicion" id="fecha_adquisicion" class="form-control" value="<?php echo e(old('fecha_adquisicion', optional($equipo->fecha_adquisicion)->format('Y-m-d'))); ?>">
                        </div>
                    </div>

                    <!-- Oficina y tipo -->
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="oficina_id" class="form-label">Oficina *</label>
                            <select name="oficina_id" id="oficina_id" class="form-select" required>
                                <option value="">Seleccionar oficina</option>
                                <?php $__currentLoopData = $oficinas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $oficina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($oficina->id); ?>" <?php echo e(old('oficina_id', $equipo->oficina_id) == $oficina->id ? 'selected' : ''); ?>>
                                        <?php echo e($oficina->nombre_oficina); ?> (<?php echo e($oficina->agencia->nombre_agencia); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="tipoequipo_id" class="form-label">Tipo de Equipo *</label>
                            <select name="tipoequipo_id" id="tipoequipo_id" class="form-select" required>
                                <option value="">Seleccionar tipo</option>
                                <?php $__currentLoopData = $tipoequipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($tipo->id); ?>" <?php echo e(old('tipoequipo_id', $equipo->tipoequipo_id) == $tipo->id ? 'selected' : ''); ?>>
                                        <?php echo e($tipo->nombre_tipo); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <!-- Modelo y hardware -->
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="modelo_id" class="form-label">Modelo *</label>
                            <select name="modelo_id" id="modelo_id" class="form-select" required>
                                <option value="">Seleccionar modelo</option>
                                <?php $__currentLoopData = $modelos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modelo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($modelo->id); ?>" <?php echo e(old('modelo_id', $equipo->modelo_id) == $modelo->id ? 'selected' : ''); ?>>
                                        <?php echo e($modelo->nombre_modelo); ?> (<?php echo e($modelo->marca->nombre_marca); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="hardware_id" class="form-label">Hardware *</label>
                            <select name="hardware_id" id="hardware_id" class="form-select" required>
                                <option value="">Seleccionar hardware</option>
                                <?php $__currentLoopData = $hardwares; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hardware): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($hardware->id); ?>" <?php echo e(old('hardware_id', $equipo->hardware_id) == $hardware->id ? 'selected' : ''); ?>>
                                        <?php echo e($hardware->procesador); ?> | <?php echo e($hardware->ram_gb); ?>GB RAM | <?php echo e($hardware->almacenamiento_gb); ?>GB <?php echo e($hardware->tipo_almacenamiento); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <!-- Sistema operativo y responsable -->
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="sistemaoperativo_id" class="form-label">Sistema Operativo *</label>
                            <select name="sistemaoperativo_id" id="sistemaoperativo_id" class="form-select" required>
                                <option value="">Seleccionar SO</option>
                                <?php $__currentLoopData = $sistemas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $so): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($so->id); ?>" <?php echo e(old('sistemaoperativo_id', $equipo->sistemaoperativo_id) == $so->id ? 'selected' : ''); ?>>
                                        <?php echo e($so->nombre_so); ?> <?php echo e($so->edicion); ?> (<?php echo e($so->version); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="responsable_id" class="form-label">Responsable *</label>
                            <select name="responsable_id" id="responsable_id" class="form-select">
                                <option value="">Seleccionar responsable</option>
                                <?php $__currentLoopData = $responsables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $responsable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($responsable->id); ?>" <?php echo e(old('responsable_id', $equipo->responsable_id) == $responsable->id ? 'selected' : ''); ?>>
                                        <?php echo e($responsable->nombre_responsable); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <!-- Estado y mantenimiento -->
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="estado_equipo" class="form-label">Estado del Equipo *</label>
                            <select name="estado_equipo" id="estado_equipo" class="form-select" required>
                                <option value="Activo" <?php echo e(old('estado_equipo', $equipo->estado_equipo) == 'Activo' ? 'selected' : ''); ?>>Activo</option>
                                <option value="Inactivo" <?php echo e(old('estado_equipo', $equipo->estado_equipo) == 'Inactivo' ? 'selected' : ''); ?>>Inactivo</option>
                                <option value="Baja" <?php echo e(old('estado_equipo', $equipo->estado_equipo) == 'Baja' ? 'selected' : ''); ?>>Baja</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="fecha_mantenimiento" class="form-label">Último Mantenimiento</label>
                            <input type="date" name="fecha_mantenimiento" id="fecha_mantenimiento" class="form-control" value="<?php echo e(old('fecha_mantenimiento', optional($equipo->fecha_mantenimiento)->format('Y-m-d'))); ?>">
                        </div>
                    </div>

                    <!-- VPNs y antivirus -->
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="vpn_cusco" class="form-label">VPN Cusco</label>
                            <select name="vpn_cusco" id="vpn_cusco" class="form-select">
                                <option value="Sí" <?php echo e(old('vpn_cusco', $equipo->vpn_cusco) == 'Sí' ? 'selected' : ''); ?>>Sí</option>
                                <option value="No" <?php echo e(old('vpn_cusco', $equipo->vpn_cusco) == 'No' ? 'selected' : ''); ?>>No</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label for="vpn_abancay" class="form-label">VPN Abancay</label>
                            <select name="vpn_abancay" id="vpn_abancay" class="form-select">
                                <option value="Sí" <?php echo e(old('vpn_abancay', $equipo->vpn_abancay) == 'Sí' ? 'selected' : ''); ?>>Sí</option>
                                <option value="No" <?php echo e(old('vpn_abancay', $equipo->vpn_abancay) == 'No' ? 'selected' : ''); ?>>No</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label for="antivirus" class="form-label">Antivirus</label>
                            <input type="text" name="antivirus" id="antivirus" class="form-control" value="<?php echo e(old('antivirus', $equipo->antivirus)); ?>">
                        </div>
                    </div>

                    <!-- Campos de texto largos -->
                    <div class="mb-3">
                        <label for="depreciacion_anual" class="form-label">Depreciación Anual (%)</label>
                        <input type="number" step="0.01" name="depreciacion_anual" id="depreciacion_anual" class="form-control" value="<?php echo e(old('depreciacion_anual', $equipo->depreciacion_anual)); ?>">
                    </div>

                    <div class="mb-3">
                        <label for="programas_instalados" class="form-label">Programas Instalados</label>
                        <textarea name="programas_instalados" id="programas_instalados" class="form-control" rows="3"><?php echo e(old('programas_instalados', $equipo->programas_instalados)); ?></textarea>
                    </div>

                    <div class="mb-3">
                        <label for="licencias" class="form-label">Licencias</label>
                        <textarea name="licencias" id="licencias" class="form-control" rows="2"><?php echo e(old('licencias', $equipo->licencias)); ?></textarea>
                    </div>

                    <div class="mb-3">
                        <label for="copias_seguridad" class="form-label">Copias de Seguridad</label>
                        <textarea name="copias_seguridad" id="copias_seguridad" class="form-control" rows="2"><?php echo e(old('copias_seguridad', $equipo->copias_seguridad)); ?></textarea>
                    </div>

                    <div class="mb-3">
                        <label for="observacion" class="form-label">Observaciones</label>
                        <textarea name="observacion" id="observacion" class="form-control" rows="3"><?php echo e(old('observacion', $equipo->observacion)); ?></textarea>
                    </div>

                    <!-- Botones -->
                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="<?php echo e(route('equipos.index')); ?>" class="btn btn-secondary me-md-2">Cancelar</a>
                        <button type="submit" class="btn btn-warning">Actualizar</button>
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Andespc\resources\views/admin/equipos/edit.blade.php ENDPATH**/ ?>