<?php $__env->startSection('title', 'Listado de Equipos'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0"><i class="bi bi-pc-display"></i> Equipos Registrados</h2>
    <a href="<?php echo e(route('equipos.create')); ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Nuevo Equipo
    </a>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="card shadow-sm">
    <div class="card-header bg-light d-flex justify-content-between align-items-center">
        <strong><i class="bi bi-list-check"></i> Lista de Equipos</strong>
        <!-- Buscador -->
        <form action="<?php echo e(route('equipos.index')); ?>" method="GET" class="d-flex">
            <input type="text" name="search" class="form-control form-control-sm me-2" placeholder="Buscar..." value="<?php echo e(request('search')); ?>">
            <button class="btn btn-sm btn-outline-primary" type="submit">
                <i class="bi bi-search"></i>
            </button>
        </form>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Dispositivo</th>
                        <th>Serie</th>
                        <th>IP</th>
                        <th>Oficina</th>
                        <th>Tipo</th>
                        <th class="text-center">Estado</th>
                        <th class="text-center">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $equipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $equipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($equipo->nombre_dispositivo); ?></td>
                            <td><?php echo e($equipo->numero_serie ?? 'N/A'); ?></td>
                            <td><?php echo e($equipo->direccion_ip ?? 'N/A'); ?></td>
                            <td><?php echo e($equipo->oficina->nombre_oficina ?? 'Sin oficina'); ?></td>
                            <td><?php echo e($equipo->tipoequipo->nombre_tipo ?? 'Sin tipo'); ?></td>
                            <td class="text-center">
                                <span class="badge bg-<?php echo e($equipo->estado_equipo == 'Activo' ? 'success' : ($equipo->estado_equipo == 'Inactivo' ? 'warning' : 'danger')); ?>">
                                    <?php echo e($equipo->estado_equipo); ?>

                                </span>
                            </td>
                            <td class="text-center">
                                <a href="<?php echo e(route('equipos.show', $equipo)); ?>" class="btn btn-sm btn-info" title="Ver">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <a href="<?php echo e(route('equipos.edit', $equipo)); ?>" class="btn btn-sm btn-warning" title="Editar">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <form action="<?php echo e(route('equipos.destroy', $equipo)); ?>" method="POST" class="d-inline" onsubmit="return confirm('¿Eliminar este equipo?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" title="Eliminar">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted">
                                <i class="bi bi-exclamation-circle"></i> No hay equipos registrados.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Paginación -->
        <div class="d-flex justify-content-center mt-3">
            <?php echo e($equipos->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Andespc\resources\views/admin/equipos/index.blade.php ENDPATH**/ ?>